	parameter (nn=10000)
	implicit real*8 (a-h,m,o-z)
	implicit integer (i,j,k,l,n)

	integer pgopen,numpts
        character*80 filein,filein1,filein2
	character line*4,iso*3
	character*30 xlabel,ylabel,label
	real*4 xmin,xmax,ymin,ymax
	real*4 t(nn),H1(nn),He4(nn),C12(nn),C13(nn),N13(nn),N14(nn)
	real*4 N15(nn),O15(nn),O16(nn),O17(nn),O18(nn),F17(nn)
	real*4 F18(nn),F19(nn)

        xmin=100
        xmax=-100
        ymin=100
        ymax=-100

 20	print*,' Enter the root name of the output file you want to read in'
	read 100,filein

C We assume here that we always want the 0002_z1 and 0003_z1 version of the files!
C So we now add that suffix to the root name.
C Note that the filein is 8- characters long so we need to truncate it at the first blank character!

	index=1
 80	continue
 81	   format(i3, ' ', a1)
	   if(filein(index:index).eq.' ') go to 82
	   index=index+1
	go to 80

 82	continue
	index=index-1
	filein1=filein(1:index)//'-2.dat'
	filein2=filein(1:index)//'-3.dat'
 100	format(a)


c open file to read data
	open(10,name=filein1,status='unknown',form='formatted')
	open(20,name=filein2,status='unknown',form='formatted')


	read(10,*)		! used for empty line at start
	read(10,*)		! used for empty line at start
        read(10,*)		! used for empty line at start
	read(20,*)		! used for empty line at start
	read(20,*)		! used for empty line at start
        read(20,*)		! used for empty line at start

	write(6,*) 'Enter 1 for log10(abudance), 0 for abundance'
	read(5,*) ialog
	write(6,*) 'Enter 1 for log(time), 0 for time'
	read(5,*) itlog

C Decide which things to plot

	iH1=1
	iHe4=1
	iC12=1
	iC13=1
	iN13=1
	iN14=1
	iN15=1
	iO15=1
	iO16=1
	iO17=1
	iO18=1
	iF17=1
	iF18=1
	iF19=1


c Read in data (coordinates) - until reach the end of file 

 200	continue
	read(10,*,end=11) j,t(j),H1(j),He4(j),C12(j),C13(j),N13(j),
     &                          N14(j),N15(j),O15(j)

 11	read(20,*,end=1)  j,t(j),O16(j),O17(j),O18(j),F17(j),F18(j),F19(j)

	t(j)=t(j)/31536000
	if(itlog.eq.1) t(j)=log10(t(j)+1.d-20)

	if(ialog.eq.1) then
          H1(j)=log10(H1(j))
          He4(j)=log10(He4(j))
          C12(j)=log10(C12(j))
          C13(j)=log10(C13(j))
          N13(j)=log10(N13(j))
          N14(j)=log10(N14(j))
          N15(j)=log10(N15(j))
          O15(j)=log10(O15(j))
          O16(j)=log10(O16(j))
          O17(j)=log10(O17(j))
          O18(j)=log10(O18(j))
          F17(j)=log10(F17(j))
          F18(j)=log10(F18(j))
          F19(j)=log10(F19(j))
	endif
	go to 200

 1      continue
        numpts=j

        close(10)

        print*,'Number of points to plot = ',numpts

c alter viewscreen to fit all data points
        do i=1,numpts
	   xmax=max(xmax,t(i))
	   xmin=min(xmin,t(i))
	   ymax=max(ymax,H1(i))
	   ymin=min(ymin,H1(i))
	   ymax=max(ymax,He4(i))
	   ymin=min(ymin,He4(i))
	   ymax=max(ymax,C12(i))
	   ymin=min(ymin,C12(i))
	   ymax=max(ymax,C13(i))
	   ymin=min(ymin,C13(i))
	   ymax=max(ymax,N13(i))
	   ymin=min(ymin,N13(i))
	   ymax=max(ymax,N14(i))
	   ymin=min(ymin,N14(i))
	   ymax=max(ymax,N15(i))
	   ymin=min(ymin,N15(i))
	   ymax=max(ymax,O15(i))
	   ymin=min(ymin,O15(i))
	   ymax=max(ymax,O16(i))
	   ymin=min(ymin,O16(i))
	   ymax=max(ymax,O17(i))
	   ymin=min(ymin,O17(i))
	   ymax=max(ymax,O18(i))
	   ymin=min(ymin,O18(i))
	   ymax=max(ymax,F17(i))
	   ymin=min(ymin,F17(i))
	   ymax=max(ymax,F18(i))
	   ymin=min(ymin,F18(i))
	   ymax=max(ymax,F19(i))
	   ymin=min(ymin,F19(i))
        enddo

	xmin=max(xmin,-8.)
	ymin=max(ymin,-15.)

 30	continue
***** Plot data points *****
c	if(pgopen('/gif').lt.0)stop  ! output to "pgplot.gif"
c	if(pgopen('/ps').lt.0)stop   ! output to "pgplot.ps"
c	if(pgopen('/cps').lt.0)stop  ! output to "pgplot.ps" (colour version)
	if(pgopen('/xs').lt.0)stop   ! output to screen

        CALL PGBEG(0,'?',1,1)

	call pgsch(1.0)  ! sets text size

	call pgsci(1)  ! set colour
c basic colours are: 0-black, 1-white, 2-red, 3-green, 4-blue ... 15

	call pgenv(xmin,xmax,ymin,ymax,0,1)
c defines the viewing window by the x any y max/min values


	if(itlog.eq.0) then
	   xlabel='time (years)'
	else
	   xlabel='log10 time (years)'
	endif

	if(ialog.eq.0) then
	   ylabel='Mass Fraction'
	else
	   ylabel='log10 Mass Fraction'
	endif
	label='CNO Cycles'
        call pglab(xlabel,ylabel,label)



c NOTE that the points can also be plotted with
c        call pgpoint(numpts,x,y,1)

	if(ih1.eq.1) then
          call pgsci(2)
	  call pgsls(1)
          call pgline(numpts,t,H1)
          write(line,510)
          call pgmtxt('T',1.0,0.0,0.0,line)
 510      format('H1')
	endif

	if(ihe4.eq.1) then
          call pgsci(3)
	  call pgsls(1)
          call pgline(numpts,t,He4)
          write(line,520)
          call pgmtxt('T',1.0,0.077,0.25,line)
 520      format('He4')
	endif

	if(ic12.eq.1) then
          call pgsci(4)
	  call pgsls(1)
          call pgline(numpts,t,C12)
          write(line,530)
          call pgmtxt('T',1.0,0.154,0.5,line)
 530      format('C12')
	endif

	if(ic13.eq.1) then
          call pgsci(5)
	  call pgsls(1)
          call pgline(numpts,t,C13)
          write(line,540)
          call pgmtxt('T',1.0,0.231,0.5,line)
 540      format('C13')
	endif

	if(in13.eq.1) then
          call pgsci(6)
	  call pgsls(2)
          call pgline(numpts,t,N13)
          write(line,550)
          call pgmtxt('T',1.0,0.308,0.5,line)
 550      format('N13')
	endif

	if(in14.eq.1) then
          call pgsci(7)
	  call pgsls(1)
          call pgline(numpts,t,N14)
          write(line,560)
          call pgmtxt('T',1.0,0.385,0.5,line)
 560      format('N14')
	endif

	if(in15.eq.1) then
          call pgsci(8)
	  call pgsls(1)
          call pgline(numpts,t,N15)
          write(line,570)
          call pgmtxt('T',1.0,0.462,0.5,line)
 570      format('N15')
	endif

	if(io15.eq.1) then
          call pgsci(9)
	  call pgsls(2)
          call pgline(numpts,t,O15)
          write(line,580)
          call pgmtxt('T',1.0,0.539,0.5,line)
 580      format('O15')
	endif

	if(io16.eq.1) then
          call pgsci(10)
	  call pgsls(1)
          call pgline(numpts,t,O16)
          write(line,590)
          call pgmtxt('T',1.0,0.616,0.5,line)
 590      format('O16')
	endif

	if(io17.eq.1) then
          call pgsci(11)
	  call pgsls(1)
          call pgline(numpts,t,O17)
          write(line,600)
          call pgmtxt('T',1.0,0.693,0.5,line)
 600      format('O17')
	endif

	if(io18.eq.1) then
          call pgsci(12)
	  call pgsls(1)
          call pgline(numpts,t,O18)
          write(line,610)
          call pgmtxt('T',1.0,0.77,0.5,line)
 610      format('O18')
	endif

	if(if17.eq.1) then
          call pgsci(13)
	  call pgsls(2)
          call pgline(numpts,t,F17)
          write(line,620)
          call pgmtxt('T',1.0,0.847,0.5,line)
 620      format('F17')
	endif

	if(if18.eq.1) then
          call pgsci(14)
	  call pgsls(2)
          call pgline(numpts,t,F18)
          write(line,630)
          call pgmtxt('T',1.0,0.924,0.75,line)
 630      format('F18')
	endif

	if(if19.eq.1) then
          call pgsci(15)
	  call pgsls(1)
          call pgline(numpts,t,F19)
          write(line,640)
          call pgmtxt('T',1.0,1.0,1.0,line)
 640      format('F19')
	endif



	call pgclos
c always need this to finish pgplot with


c       Option ot alter viewing window
	write(6,*) ' Enter 1 to alter viewing region, 0 to exit'
	read(5,*) idecide
	if(idecide.eq.0) stop
	if(idecide.eq.1) then
	   write(6,*) 'Enter xmin,xmax,ymin,ymax'
	   read(5,*) xmin,xmax,ymin,ymax
	   go to 30
	endif


	end  ! end of program


